#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Reflection;
using System.Text;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using VBECSDateTime = gov.va.med.vbecs.BOL.VBECSDateTime;
using ListViewSubItem = System.Windows.Forms.ListViewItem.ListViewSubItem;
#endregion

namespace gov.va.med.vbecs.GUI
{
	#region Header

		//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		//<Developers>
		//	<Developer>Margaret Jablonski</Developer>
		//</Developers>
		//<SiteName>Hines OIFO</SiteName>
		//<CreationDate>7/13/2004</CreationDate>
		//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		//<summary></summary>

		#endregion

	/// <summary>
	/// Class FrmViewDeceasedPatients
	/// </summary>
	public class FrmViewDeceasedPatients : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Delegates
		
		private event EventHandler onViewedDeceased;

		#endregion

		#region Controls

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.GroupBox grpPatients;
		private System.Windows.Forms.ListView lvPatients;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.Label lblDeceasedPatients;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmViewDeceasedPatients));
			this.btnClose = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpPatients = new System.Windows.Forms.GroupBox();
			this.lblDeceasedPatients = new System.Windows.Forms.Label();
			this.lvPatients = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.grpImage.SuspendLayout();
			this.grpPatients.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(704, 30);
			this.vbecsLogo1.TabIndex = 2;
			this.vbecsLogo1.Title = "View Deceased Patient List";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 357);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// btnClose
			// 
			this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnClose.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnClose.Location = new System.Drawing.Point(626, 341);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 0;
			this.btnClose.Text = "&Close";
			this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 301);
			this.grpImage.TabIndex = 3;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Enabled = false;
			this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpPatients
			// 
			this.grpPatients.AccessibleDescription = "Deceased Patients with Active/Pending Orders";
			this.grpPatients.AccessibleName = "Deceased Patients with Active/Pending Orders";
			this.grpPatients.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatients.Controls.Add(this.lblDeceasedPatients);
			this.grpPatients.Controls.Add(this.lvPatients);
			this.grpPatients.Location = new System.Drawing.Point(60, 32);
			this.grpPatients.Name = "grpPatients";
			this.grpPatients.Size = new System.Drawing.Size(640, 301);
			this.grpPatients.TabIndex = 1;
			this.grpPatients.TabStop = false;
			// 
			// lblDeceasedPatients
			// 
			this.lblDeceasedPatients.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblDeceasedPatients.Location = new System.Drawing.Point(8, 16);
			this.lblDeceasedPatients.Name = "lblDeceasedPatients";
			this.lblDeceasedPatients.Size = new System.Drawing.Size(624, 16);
			this.lblDeceasedPatients.TabIndex = 0;
			this.lblDeceasedPatients.Text = "Deceased Patients with Active/Pending Orders";
			this.lblDeceasedPatients.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvPatients
			// 
			this.lvPatients.AccessibleDescription = "Deceased Patients with Active/Pending Orders";
			this.lvPatients.AccessibleName = "Deceased Patients with Active/Pending Orders";
			this.lvPatients.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvPatients.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader1,
																						 this.columnHeader2,
																						 this.columnHeader3,
																						 this.columnHeader4,
																						 this.columnHeader5});
			this.lvPatients.FullRowSelect = true;
			this.lvPatients.HideSelection = false;
			this.lvPatients.Location = new System.Drawing.Point(8, 36);
			this.lvPatients.MultiSelect = false;
			this.lvPatients.Name = "lvPatients";
			this.lvPatients.Size = new System.Drawing.Size(624, 257);
			this.lvPatients.TabIndex = 1;
			this.lvPatients.View = System.Windows.Forms.View.Details;
			this.lvPatients.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvPatients_ColumnClick);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Patient Name";
			this.columnHeader1.Width = 100;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Patient ID";
			this.columnHeader2.Width = 80;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Date of Birth";
			this.columnHeader3.Width = 80;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Patient Deceased  Date";
			this.columnHeader4.Width = 130;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Date Updated";
			this.columnHeader5.Width = 98;
			// 
			// FrmViewDeceasedPatients
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnClose;
			this.ClientSize = new System.Drawing.Size(704, 373);
			this.Controls.Add(this.grpPatients);
			this.Controls.Add(this.btnClose);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Updated_Patients_and_Deceased_Patients.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(488, 400);
			this.Name = "FrmViewDeceasedPatients";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - View Deceased Patient List";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FrmViewDeceasedPatients_Closing);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnClose, 0);
			this.Controls.SetChildIndex(this.grpPatients, 0);
			this.grpImage.ResumeLayout(false);
			this.grpPatients.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Constructors/Dispose
		/// <summary>
		/// Constructor
		/// </summary>
		public FrmViewDeceasedPatients()
		{
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC068.FrmViewDeceasedPatients());
			//
			LoadListView();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Events / Event Handlers

		/// <summary>
		/// DeceasedViewed
		/// </summary>
		public event EventHandler ViewedDeceased
		{
			add
			{
				onViewedDeceased += value;
			}
			remove
			{
				onViewedDeceased -= value;
			}
		}

		/// <summary>
		/// OnViewedDeceased
		/// </summary>
		private void OnViewedDeceased(object sender, EventArgs e)
		{
			if (onViewedDeceased != null)
			{
				onViewedDeceased(this, e);
			}
		}

		/// <summary>
		/// Close
		/// </summary>
		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// FrmViewDeceasedPatients_Closing
		/// Implements BR_68.12
		/// </summary>
		private void FrmViewDeceasedPatients_Closing(object sender, CancelEventArgs e)
		{
			// Clear the alert icon
			OnViewedDeceased(null, EventArgs.Empty);
		}

		/// <summary>
		/// Sorts the list
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvPatients_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 2 || e.Column == 3)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, false, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, false, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// LoadListView
		/// </summary>
		private void LoadListView()
		{
			PatientChange [] deceasedPatientList = BOL.PatientChange.GetRecentlyDeceasedPatientsDetails();
			//
			if (deceasedPatientList != null)
			{
				string currentDivision = Common.LogonUser.LogonUserDivisionCode; // CR 3164
				int recordCount = deceasedPatientList.Length;
				if(recordCount > 0)
				{
					for (int idx = 0; idx < recordCount; idx++)
					{
						ListViewItem lVI = new ListViewItem();	
						//
						// Patient Name
						lVI.Text = Patient.BuildDisplayName(deceasedPatientList[idx].ToPatientFirstName, deceasedPatientList[idx].ToPatientMiddleName, deceasedPatientList[idx].ToPatientLastName);
						//
						// Patient ID
						lVI.SubItems.Add(deceasedPatientList[idx].ToPatientDisplayVistaPatientId);
						//
						// Patient DOB
						lVI.SubItems.Add(Common.VBECSDateTime.FormatDateString(deceasedPatientList[idx].ToPatientDob));
						//
						// Patient Deceased Date
						if(deceasedPatientList[idx].ToPatientDeathDate.Equals(DateTime.MinValue))
						{
							lVI.SubItems.Add(string.Empty);
						}
						else
						{
							lVI.SubItems.Add(Common.VBECSDateTime.FormatDateString(deceasedPatientList[idx].ToPatientDeathDate));
						}
						//					
						// Date Updated
						// CR 3043: use NotificationReceivedDate as UpdateDate; LastUpdateDate gets set when a record is viewed so does not
						// always accurately describe when the patient update was processed.
						lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(deceasedPatientList[idx].NotificationReceivedDate));
						//
						lVI.Tag = deceasedPatientList[idx];
						//
						this.lvPatients.Items.Add(lVI);
						//
						if( deceasedPatientList[idx].PatientChangeStatusCode != Common.PatientChangeStatus.SuccessfullyProcessed )
						{
							// CR 3164: we need to mark the records the user viewed as such, so they will not appear in the user alert;
							// to do this we add the current division code to updatedPatientList[idx].ActiveDivisions and update the DB.
							// We only update status to 'Successfully Processed' after at least one user in each division with an active 
							// order has viewed the update(s).
							ArrayList divisionsWithActiveOrdersList = null;
							if ( deceasedPatientList[idx].DivisionsWithActiveOrders != null && deceasedPatientList[idx].DivisionsWithActiveOrders.Length > 0 ) 
							{ 
								divisionsWithActiveOrdersList = new ArrayList( deceasedPatientList[idx].DivisionsWithActiveOrders.Split(PatientChange.DivisionDelimiterSplitter) ); 
							}
							//
							ArrayList activeDivisionsAlertViewedList = null;
							if ( deceasedPatientList[idx].ActiveDivisionsAlertViewed != null && deceasedPatientList[idx].ActiveDivisionsAlertViewed.Length > 0 ) 
							{ 
								activeDivisionsAlertViewedList = new ArrayList( deceasedPatientList[idx].ActiveDivisionsAlertViewed.Split(PatientChange.DivisionDelimiterSplitter) ); 
							}
							//
							if ( divisionsWithActiveOrdersList != null && divisionsWithActiveOrdersList.Count > 0 && divisionsWithActiveOrdersList.Contains(currentDivision)
								&& (activeDivisionsAlertViewedList != null && activeDivisionsAlertViewedList.Count > 0 && !activeDivisionsAlertViewedList.Contains(currentDivision)
								|| (activeDivisionsAlertViewedList == null || activeDivisionsAlertViewedList.Count == 0)) )
							{
								if ( activeDivisionsAlertViewedList == null ){ activeDivisionsAlertViewedList = new ArrayList(); }
								activeDivisionsAlertViewedList.Add(currentDivision); 
								//
								if ( deceasedPatientList[idx].AllUpdatesViewed(activeDivisionsAlertViewedList, divisionsWithActiveOrdersList) )
								{
									deceasedPatientList[idx].ActiveDivisionsAlertViewed = null;
									deceasedPatientList[idx].PatientChangeStatusCode = Common.PatientChangeStatus.SuccessfullyProcessed;
								}
								else
								{
									deceasedPatientList[idx].ActiveDivisionsAlertViewed = PatientChange.BuildAlertViewedString( currentDivision, activeDivisionsAlertViewedList );
								}
								//
								deceasedPatientList[idx].UpdatePatientChangeStatus();

							} // end: if ( (activeDivisionsList != null ...
						} // end: if(deceasedPatientList[idx].PatientChangeStatusCode ...
					} // end: for (int idx = 0; idx < recordCount; idx++)
				} // end: if(recordCount > 0)
			} // end: if (deceasedPatientList != null)
			else
			{
				// No units found in database
				ListViewItem lvItem = new ListViewItem(Common.StrRes.SysErrMsg.Common.NoDataRowsFoundException("").ResString);
				this.lvPatients.Items.Add(lvItem);
				lvItem.Tag = null;
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvPatients);
		}

		#endregion
	}
}

